#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=..\..\ICON\SHELL32\009_shell32.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_UseAnsi=y
#AutoIt3Wrapper_Res_Description=d3mon Corporation
#AutoIt3Wrapper_Res_Fileversion=1.1.0.0
#AutoIt3Wrapper_Res_LegalCopyright=d3mon Corporation. All rights reserved.
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include <Include\GUICtrlSetOnHover_UDF.au3> ; http://www.autoitscript.com/forum/index.php?showtopic=55120
#include <Include\ModernMenuRaw.au3> ; http://www.autoitscript.com/forum/index.php?showtopic=20967
#include <Include\IsPressed_UDF.au3> ; http://www.autoitscript.com/forum/index.php?showtopic=86296
#include <Include\FileInstall.au3>
;


Local $display = ' http://www.autoitscript.com/ -', $o_text = StringLen($display), $CGUI = True, $getauto = False, $init = 30001
Local $objWMIService = ObjGet('winmgmts:\\.\root\WMI'), $getArray = 127

#Region Opt  & Install
Opt('GUIOnEventMode', 1)
Opt('TrayOnEventMode', 1)
Opt('TrayMenuMode', 1)

;~ _FileInstall_CreateFileList('Picture', @TempDir, 1, '*', 'FileInstall', True)
#EndRegion Opt  & Install
;

#Region Tray
$tray = _TrayIconCreate('Drive temp - d3monCorp')
_TrayCreateContextMenu($tray)
_TrayCreateItem('Show')
_TrayItemSetIcon(-1, 'shell32.dll', -145)
GUICtrlSetOnEvent(-1, '_SHOW')
_TrayCreateItem('Hide')
_TrayItemSetIcon(-1, 'shell32.dll', -154)
GUICtrlSetOnEvent(-1, '_HIDE')
_TrayCreateItem('')
_TrayCreateItem('Exit')
_TrayItemSetIcon(-1, 'shell32.dll', -028)
GUICtrlSetOnEvent(-1, '_Exit')
_TrayIconSetState($tray, @SW_SHOW)
#EndRegion Tray
;

#Region GUI
$GUI = GUICreate('Drive temprature', 165, 90, -1, -1, 0x80000000 + 0x00800000)
GUISetOnEvent(-7, '_DRAG', $GUI)
GUICtrlCreatePic(@TempDir & '\back_pic.JPG', 0, 0, 165, 90, 128)

$tmp = GUICtrlCreateLabel('0 C', 10, 28, 100, 40, 1)
GUICtrlSetBkColor($tmp, -2)
GUICtrlSetFont($tmp, 24)

#Region SysMenu
GUICtrlCreateLabel('Drive temp', 5, 0, 75, 15)
GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetBkColor(-1, -2)

$title = GUICtrlCreateLabel('Shutdown - d3mon Corporation ', 2, 77, 160, 15)
GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetBkColor(-1, -2)

$minimize = GUICtrlCreatePic(@TempDir & '\Minimize.bmp', 103, 1, 33, 13)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_MINIMIZE')

$close = GUICtrlCreatePic(@TempDir & '\Close.bmp', 136, 1, 30, 13)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_HIDE')

$config = GUICtrlCreatePic(@TempDir & '\Config.bmp', 75, 1, 30, 13)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_GCONFIG')
#EndRegion SysMenu

$refresh = GUICtrlCreatePic(@TempDir & '\Refresh.bmp', 135, 45, 20, 20)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_RefreshTemp')

GUISetBkColor(0xFFFFFF, $GUI)
;~ DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 250, 'long', 0x00080000)
GUISetState(@SW_SHOW, $GUI)
#EndRegion GUI

#Region 2GUI
$2GUI = GUICreate('Config', 165, 75, -1, @DesktopHeight + 100, 0x80000000 + 0x00800000, -1, $GUI)
GUISetOnEvent(-7, '_DRAG', $2GUI)
GUICtrlCreatePic(@TempDir & '\back_pic2.JPG', 0, 0, 165, 75, 128)

GUICtrlCreateLabel('Use temperature array :', 5, 18)
$Array = GUICtrlCreateEdit('139', 130, 16, 30, 17, 128)

$auto = GUICtrlCreateCheckbox('Refresh every 30sec', 5, 35)

$apply = GUICtrlCreatePic(@TempDir & '\Apply.bmp', 55, 62, 55, 14)
GUICtrlSetOnHover(-1, 'Hover_Func', 'Leave_Hover_Func')
GUICtrlSetOnEvent(-1, '_Apply')

GUISetState(@SW_SHOW, $2GUI)
#EndRegion 2GUI
;
#Region Hover
Func Hover_Func($CtrlID)
	Switch $CtrlID
		Case $close
			GUICtrlSetImage($CtrlID, @TempDir & '\Close-o.bmp')
		Case $minimize
			GUICtrlSetImage($CtrlID, @TempDir & '\Minimize-o.bmp')
		Case $config
			GUICtrlSetImage($CtrlID, @TempDir & '\Config-o.bmp')
		Case $apply
			GUICtrlSetImage($CtrlID, @TempDir & '\Apply-o.bmp')
		Case $refresh
			GUICtrlSetImage($CtrlID, @TempDir & '\Refresh-o.bmp')
	EndSwitch
EndFunc   ;==>Hover_Func

Func Leave_Hover_Func($CtrlID)
	Switch $CtrlID
		Case $close
			GUICtrlSetImage($CtrlID, @TempDir & '\Close.bmp')
		Case $minimize
			GUICtrlSetImage($CtrlID, @TempDir & '\Minimize.bmp')
		Case $config
			GUICtrlSetImage($CtrlID, @TempDir & '\Config.bmp')
		Case $apply
			GUICtrlSetImage($CtrlID, @TempDir & '\Apply.bmp')
		Case $refresh
			GUICtrlSetImage($CtrlID, @TempDir & '\Refresh.bmp')
	EndSwitch
EndFunc   ;==>Leave_Hover_Func
#EndRegion Hover

Func _HIDE()
	GUICtrlSetImage($close, @TempDir & '\Close-p.bmp')
	While _IsPressed('01')
	WEnd
	$CGUI = False
;~ 	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $2GUI, 'int', 200, 'long', 0x00050008)
	GUISetState(@SW_HIDE, $2GUI)
;~ 	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 200, 'long', 0x00090000)
	GUISetState(@SW_HIDE, $GUI)
	GUICtrlSetImage($close, @TempDir & '\Close.bmp')
EndFunc   ;==>_HIDE

Func _MINIMIZE()
	GUICtrlSetImage($minimize, @TempDir & '\Minimize-p.bmp')
	While _IsPressed('01')
	WEnd
	GUISetState(@SW_MINIMIZE, $GUI)
	GUICtrlSetImage($minimize, @TempDir & '\Minimize.bmp')
EndFunc   ;==>_MINIMIZE

Func _SHOW()
;~ 	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $GUI, 'int', 250, 'long', 0x00080000)
	GUISetState(@SW_SHOW, $GUI)
EndFunc   ;==>_SHOW

Func _DRAG()
	$wgp = WinGetPos($GUI)
	$mgp = MouseGetPos()
	While _IsPressed('01')
		$mgp1 = MouseGetPos()
		WinMove($GUI, '', $wgp[0] - ($mgp[0] - $mgp1[0]), $wgp[1] - ($mgp[1] - $mgp1[1]))
		WinMove($2GUI, '', $wgp[0] - ($mgp[0] - $mgp1[0]), $wgp[1] - ($mgp[1] - $mgp1[1]) + 100)
	WEnd
EndFunc   ;==>_DRAG

Func _GCONFIG()
	If $CGUI = True Then
		_HCONFIG()
	Else
		_SCONFIG()
	EndIf
EndFunc   ;==>_GCONFIG

Func _SCONFIG()
	GUICtrlSetImage($config, @TempDir & '\Config-p.bmp')
	While _IsPressed('01')
	WEnd
	$CGUI = True
	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $2GUI, 'int', 250, 'long', 0x00040004)
	GUISetState(@SW_SHOW, $2GUI)
	GUICtrlSetImage($config, @TempDir & '\Config.bmp')
EndFunc   ;==>_SCONFIG

Func _HCONFIG()
	GUICtrlSetImage($config, @TempDir & '\Config-p.bmp')
	While _IsPressed('01')
	WEnd
	$CGUI = False
	DllCall('user32.dll', 'int', 'AnimateWindow', 'hwnd', $2GUI, 'int', 200, 'long', 0x00050008)
	GUISetState(@SW_HIDE, $2GUI)
	GUICtrlSetImage($config, @TempDir & '\Config.bmp')
EndFunc   ;==>_HCONFIG

Func _Apply()
	GUICtrlSetImage($apply, @TempDir & '\Apply-p.bmp')
	While _IsPressed('01')
	WEnd
	If (GUICtrlRead($Array) = '') Then
		GUICtrlSetData($Array, 139) ;Default
		$getArray = GUICtrlRead($Array)
	EndIf
	If (GUICtrlRead($auto) = 1) Then $getauto = True
	If (GUICtrlRead($auto) = 4) Then $getauto = False
	GUICtrlSetImage($apply, @TempDir & '\Apply.bmp')
EndFunc   ;==>_Apply


While 1
	_AnimateText($title, $display, 32, 2)
	If $getauto = True Then
		If (TimerDiff($init) > 30000) Then
			$init = TimerInit()
			_RefreshTemp()
		EndIf
	EndIf
	Sleep(250)
WEnd

Func _Exit()
	_TrayIconDelete($tray)
	FileDelete(@TempDir & '\drivetemp.sav')
	FileWrite(@TempDir & '\drivetemp.sav', $getArray)
	Exit
EndFunc   ;==>_Exit

Func _RefreshTemp()
	GUICtrlSetImage($refresh, @TempDir & '\Refresh-p.bmp')
	While _IsPressed('01')
	WEnd
	GUICtrlSetData($tmp, _WMI_DriveTemperature() & ' C')
	_TrayIconSetToolTip($tray, 'Drive temp : ' & _WMI_DriveTemperature() & ' C')
	GUICtrlSetImage($refresh, @TempDir & '\Refresh.bmp')
EndFunc   ;==>_RefreshTemp


Func _WMI_DriveTemperature()
	$colTemp = $objWMIService.ExecQuery('SELECT * FROM MSStorageDriver_ATAPISmartData')
	For $objItem In $colTemp
		$strVendorSpecific = $objItem.VendorSpecific
		Return $strVendorSpecific[$getArray] ;[127]
	Next
EndFunc   ;==>_WMI_DriveTemperature

; #FUNCTION# ;============================================================================================================================================
;
; Name...........: _FileInstall_CreateFileList
; Description ...: List Install file(s) from a folder into au3
; Syntax.........: _FileInstall_CreateFileList($sSource, $sDest, $nFlag = 0, $sMask = '*', $sName = 'include', $sOverWrite = False, $sCompiled = False)
; Parameters ....: $sSource	= Source folder to get file(s) from
;                  $sDest	= Destination to install file(s) to
;                  $nFlag	= According to the flag of FileInstall	[Optional]
;				   $sMask	= Extensions of file(s) to List			[Optional]
;				   $sName	= Out au3 script name					[Optional]
;                  $sCompiled - One of the following:				[Optional]
;                  False = Always install file(s)
;                  True = Only install file(s) when the script is compiled
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: MrCreator, FireFox
; Modified.......: FireFox
; Remarks .......:
; Related .......: _WinAPI_FileInstall_CreateFileList
; Link ..........;
; Example .......;
;
; ;=======================================================================================================================================================
Func _FileInstall_CreateFileList($sSource, $sDest, $nFlag = 0, $sMask = '*', $sName = 'include', $sOverWrite = False, $sCompiled = False)
	Local $hSearch, $sNext_File, $sRet_FI_Lines = ''
	
	If (Not $sCompiled) Or ($sCompiled And @Compiled) Then
		$hSearch = FileFindFirstFile($sSource & '\' & $sMask)
		If $hSearch = -1 Then Return SetError(1, 0, 'FileFindFirstFile')
		
		While 1
			$sNext_File = FileFindNextFile($hSearch)
			If @error Then ExitLoop ;No more files
			$sRet_FI_Lines &= @CRLF & _
					'FileInstall("' & $sSource & '\' & $sNext_File & '", "' & $sDest & '\' & $sNext_File & '", ' & $nFlag & ')'
		WEnd
		FileClose($hSearch)
		If $sRet_FI_Lines = '' Then Return SetError(2, 0, '')
		If $sOverWrite Then FileDelete(@ScriptDir & '\' & $sName & '.au3')
		Return FileWrite(@ScriptDir & '\' & $sName & '.au3', StringStripWS($sRet_FI_Lines, 3))
	EndIf
	
	Return 0
EndFunc   ;==>_FileInstall_CreateFileList

; #FUNCTION# ;===============================================================================
;
; Name...........: _AnimateText
; Description ...: Animate a text in different ways
; Syntax.........: _AnimateText($Ctrl_ID, $s_text, $len, $way = 1)
; Parameters ....: $Ctrl_ID	= the control id to animate text
;				   $s_text	= text to animate
;				   $len	= Animate length limit
;				   $way	- One of the following:
;				   1 =	Animate from Left
;				   2 =	Animate from Right
; Return values .: Success - Returns 1
;                  Failure - Returns 0
; Author ........: FireFox
; Modified.......:
; Remarks .......: $o_text = 1 for $way = 1 | $o_text = StringLen($s_text) for $way = 2
; Related .......:
; Link ..........;
; Example .......;
;
; ;==========================================================================================
Func _AnimateText($Ctrl_ID, $s_text, $len, $way = 1)
	If $way = 1 Then
		$_text = GUICtrlRead($Ctrl_ID)
		$n_text = StringRight($s_text, $o_text) & $s_text
		GUICtrlSetData($Ctrl_ID, StringLeft($n_text, $len))
		$o_text += 1
		If $o_text = StringLen($s_text) Then $o_text = 1
	EndIf
	If $way = 2 Then
		$_text = GUICtrlRead($Ctrl_ID)
		$n_text = StringRight($s_text, $o_text) & $s_text
		GUICtrlSetData($Ctrl_ID, StringLeft($n_text, $len))
		$o_text -= 1
		If $o_text < 1 Then $o_text = StringLen($s_text)
	EndIf
	If Not @error Then Return 1
	Return 0
EndFunc   ;==>_AnimateText